/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddCommentRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeCommentRequest;
import com.collibra.core.rest.client.model.Comment;
import com.collibra.core.rest.client.model.CommentPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;

public interface CommentsApi
extends ApiClient.Api {
    @RequestLine(value="POST /comments")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Comment addComment(AddCommentRequest var1);

    @RequestLine(value="POST /comments")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Comment> addCommentWithHttpInfo(AddCommentRequest var1);

    @RequestLine(value="PATCH /comments/{commentId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Comment changeComment(@Param(value="commentId") UUID var1, ChangeCommentRequest var2);

    @RequestLine(value="PATCH /comments/{commentId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Comment> changeCommentWithHttpInfo(@Param(value="commentId") UUID var1, ChangeCommentRequest var2);

    @RequestLine(value="GET /comments?offset={offset}&limit={limit}&countLimit={countLimit}&parentId={parentId}&userId={userId}&baseResourceId={baseResourceId}&rootComment={rootComment}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public CommentPagedResponse findComments(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="parentId") UUID var4, @Param(value="userId") UUID var5, @Param(value="baseResourceId") UUID var6, @Param(value="rootComment") Boolean var7, @Param(value="sortOrder") String var8);

    @RequestLine(value="GET /comments?offset={offset}&limit={limit}&countLimit={countLimit}&parentId={parentId}&userId={userId}&baseResourceId={baseResourceId}&rootComment={rootComment}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CommentPagedResponse> findCommentsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="parentId") UUID var4, @Param(value="userId") UUID var5, @Param(value="baseResourceId") UUID var6, @Param(value="rootComment") Boolean var7, @Param(value="sortOrder") String var8);

    @RequestLine(value="GET /comments?offset={offset}&limit={limit}&countLimit={countLimit}&parentId={parentId}&userId={userId}&baseResourceId={baseResourceId}&rootComment={rootComment}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public CommentPagedResponse findComments(@QueryMap(encoded=true) FindCommentsQueryParams var1);

    @RequestLine(value="GET /comments?offset={offset}&limit={limit}&countLimit={countLimit}&parentId={parentId}&userId={userId}&baseResourceId={baseResourceId}&rootComment={rootComment}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CommentPagedResponse> findCommentsWithHttpInfo(@QueryMap(encoded=true) FindCommentsQueryParams var1);

    @RequestLine(value="GET /comments/{commentId}")
    @Headers(value={"Accept: application/json"})
    public Comment getComment(@Param(value="commentId") UUID var1);

    @RequestLine(value="GET /comments/{commentId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Comment> getCommentWithHttpInfo(@Param(value="commentId") UUID var1);

    @RequestLine(value="DELETE /comments/{commentId}")
    @Headers(value={"Accept: application/json"})
    public void removeComment(@Param(value="commentId") UUID var1);

    @RequestLine(value="DELETE /comments/{commentId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeCommentWithHttpInfo(@Param(value="commentId") UUID var1);

    public static class FindCommentsQueryParams
    extends HashMap<String, Object> {
        public FindCommentsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindCommentsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindCommentsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindCommentsQueryParams parentId(UUID value) {
            this.put("parentId", EncodingUtils.encode(value));
            return this;
        }

        public FindCommentsQueryParams userId(UUID value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public FindCommentsQueryParams baseResourceId(UUID value) {
            this.put("baseResourceId", EncodingUtils.encode(value));
            return this;
        }

        public FindCommentsQueryParams rootComment(Boolean value) {
            this.put("rootComment", EncodingUtils.encode(value));
            return this;
        }

        public FindCommentsQueryParams sortOrder(String value) {
            this.put("sortOrder", EncodingUtils.encode(value));
            return this;
        }
    }
}

