/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddAttributeRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.Attribute;
import com.collibra.core.rest.client.model.AttributePagedResponse;
import com.collibra.core.rest.client.model.ChangeAttributeRequest;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface AttributesApi
extends ApiClient.Api {
    @RequestLine(value="POST /attributes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Attribute addAttribute(AddAttributeRequest var1);

    @RequestLine(value="POST /attributes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Attribute> addAttributeWithHttpInfo(AddAttributeRequest var1);

    @RequestLine(value="POST /attributes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Attribute> addAttributes(List<AddAttributeRequest> var1);

    @RequestLine(value="POST /attributes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Attribute>> addAttributesWithHttpInfo(List<AddAttributeRequest> var1);

    @RequestLine(value="PATCH /attributes/{attributeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Attribute changeAttribute(@Param(value="attributeId") UUID var1, ChangeAttributeRequest var2);

    @RequestLine(value="PATCH /attributes/{attributeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Attribute> changeAttributeWithHttpInfo(@Param(value="attributeId") UUID var1, ChangeAttributeRequest var2);

    @RequestLine(value="PATCH /attributes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Attribute> changeAttributes(List<ChangeAttributeRequest> var1);

    @RequestLine(value="PATCH /attributes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Attribute>> changeAttributesWithHttpInfo(List<ChangeAttributeRequest> var1);

    @RequestLine(value="GET /attributes?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&typeIds={typeIds}&assetId={assetId}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public AttributePagedResponse findAttributes(@Param(value="sortField") String var1, @Param(value="offset") Integer var2, @Param(value="limit") Integer var3, @Param(value="countLimit") Integer var4, @Param(value="cursor") String var5, @Param(value="typeIds") List<UUID> var6, @Param(value="assetId") UUID var7, @Param(value="sortOrder") String var8);

    @RequestLine(value="GET /attributes?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&typeIds={typeIds}&assetId={assetId}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AttributePagedResponse> findAttributesWithHttpInfo(@Param(value="sortField") String var1, @Param(value="offset") Integer var2, @Param(value="limit") Integer var3, @Param(value="countLimit") Integer var4, @Param(value="cursor") String var5, @Param(value="typeIds") List<UUID> var6, @Param(value="assetId") UUID var7, @Param(value="sortOrder") String var8);

    @RequestLine(value="GET /attributes?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&typeIds={typeIds}&assetId={assetId}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public AttributePagedResponse findAttributes(@QueryMap(encoded=true) FindAttributesQueryParams var1);

    @RequestLine(value="GET /attributes?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&typeIds={typeIds}&assetId={assetId}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AttributePagedResponse> findAttributesWithHttpInfo(@QueryMap(encoded=true) FindAttributesQueryParams var1);

    @RequestLine(value="GET /attributes/{attributeId}")
    @Headers(value={"Accept: application/json"})
    public Attribute getAttribute(@Param(value="attributeId") UUID var1);

    @RequestLine(value="GET /attributes/{attributeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Attribute> getAttributeWithHttpInfo(@Param(value="attributeId") UUID var1);

    @RequestLine(value="DELETE /attributes/{attributeId}")
    @Headers(value={"Accept: application/json"})
    public void removeAttribute(@Param(value="attributeId") UUID var1);

    @RequestLine(value="DELETE /attributes/{attributeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeAttributeWithHttpInfo(@Param(value="attributeId") UUID var1);

    @RequestLine(value="DELETE /attributes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeAttributes(List<UUID> var1);

    @RequestLine(value="DELETE /attributes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeAttributesWithHttpInfo(List<UUID> var1);

    public static class FindAttributesQueryParams
    extends HashMap<String, Object> {
        public FindAttributesQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindAttributesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindAttributesQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindAttributesQueryParams cursor(String value) {
            this.put("cursor", EncodingUtils.encode(value));
            return this;
        }

        public FindAttributesQueryParams typeIds(List<UUID> value) {
            this.put("typeIds", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindAttributesQueryParams assetId(UUID value) {
            this.put("assetId", EncodingUtils.encode(value));
            return this;
        }

        public FindAttributesQueryParams sortOrder(String value) {
            this.put("sortOrder", EncodingUtils.encode(value));
            return this;
        }

        public FindAttributesQueryParams sortField(String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }
    }
}

