/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddAssignmentRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.core.rest.client.model.AssignmentImpl;
import com.collibra.core.rest.client.model.AttributeType;
import com.collibra.core.rest.client.model.ChangeAssignmentRequest;
import com.collibra.core.rest.client.model.ComplexRelationTypeImpl;
import com.collibra.core.rest.client.model.RelationTypeImpl;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface AssignmentsApi
extends ApiClient.Api {
    @RequestLine(value="POST /assignments")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AssignmentImpl addAssignment(AddAssignmentRequest var1);

    @RequestLine(value="POST /assignments")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AssignmentImpl> addAssignmentWithHttpInfo(AddAssignmentRequest var1);

    @RequestLine(value="PATCH /assignments/{assignmentId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AssignmentImpl changeAssignment(@Param(value="assignmentId") UUID var1, ChangeAssignmentRequest var2);

    @RequestLine(value="PATCH /assignments/{assignmentId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AssignmentImpl> changeAssignmentWithHttpInfo(@Param(value="assignmentId") UUID var1, ChangeAssignmentRequest var2);

    @RequestLine(value="GET /assignments/forResource?resourceId={resourceId}&resourceType={resourceType}")
    @Headers(value={"Accept: application/json"})
    public List<AssignmentImpl> findAssignmentsForResource(@Param(value="resourceId") UUID var1, @Param(value="resourceType") String var2);

    @RequestLine(value="GET /assignments/forResource?resourceId={resourceId}&resourceType={resourceType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<AssignmentImpl>> findAssignmentsForResourceWithHttpInfo(@Param(value="resourceId") UUID var1, @Param(value="resourceType") String var2);

    @RequestLine(value="GET /assignments/forResource?resourceId={resourceId}&resourceType={resourceType}")
    @Headers(value={"Accept: application/json"})
    public List<AssignmentImpl> findAssignmentsForResource(@QueryMap(encoded=true) FindAssignmentsForResourceQueryParams var1);

    @RequestLine(value="GET /assignments/forResource?resourceId={resourceId}&resourceType={resourceType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<AssignmentImpl>> findAssignmentsForResourceWithHttpInfo(@QueryMap(encoded=true) FindAssignmentsForResourceQueryParams var1);

    @RequestLine(value="GET /assignments/asset/{assetId}")
    @Headers(value={"Accept: application/json"})
    public AssignmentImpl getAssignmentsForAsset(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assignments/asset/{assetId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssignmentImpl> getAssignmentsForAssetWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assignments/assetType/{assetTypeId}")
    @Headers(value={"Accept: application/json"})
    public List<AssignmentImpl> getAssignmentsForAssetType(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="GET /assignments/assetType/{assetTypeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<AssignmentImpl>> getAssignmentsForAssetTypeWithHttpInfo(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="GET /assignments/domain/{domainId}/assetTypes")
    @Headers(value={"Accept: application/json"})
    public List<AssetTypeImpl> getAvailableAssetTypesForDomain(@Param(value="domainId") UUID var1);

    @RequestLine(value="GET /assignments/domain/{domainId}/assetTypes")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<AssetTypeImpl>> getAvailableAssetTypesForDomainWithHttpInfo(@Param(value="domainId") UUID var1);

    @RequestLine(value="GET /assignments/asset/{assetId}/attributeTypes")
    @Headers(value={"Accept: application/json"})
    public List<AttributeType> getAvailableAttributeTypesForAsset(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assignments/asset/{assetId}/attributeTypes")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<AttributeType>> getAvailableAttributeTypesForAssetWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assignments/asset/{assetId}/complexRelationTypes")
    @Headers(value={"Accept: application/json"})
    public List<ComplexRelationTypeImpl> getAvailableComplexRelationTypesForAsset(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assignments/asset/{assetId}/complexRelationTypes")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<ComplexRelationTypeImpl>> getAvailableComplexRelationTypesForAssetWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assignments/asset/{assetId}/relationTypes")
    @Headers(value={"Accept: application/json"})
    public List<RelationTypeImpl> getAvailableRelationTypesForAsset(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assignments/asset/{assetId}/relationTypes")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<RelationTypeImpl>> getAvailableRelationTypesForAssetWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="DELETE /assignments/{assignmentId}")
    @Headers(value={"Accept: application/json"})
    public void removeAssignment(@Param(value="assignmentId") UUID var1);

    @RequestLine(value="DELETE /assignments/{assignmentId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeAssignmentWithHttpInfo(@Param(value="assignmentId") UUID var1);

    public static class FindAssignmentsForResourceQueryParams
    extends HashMap<String, Object> {
        public FindAssignmentsForResourceQueryParams resourceId(UUID value) {
            this.put("resourceId", EncodingUtils.encode(value));
            return this;
        }

        public FindAssignmentsForResourceQueryParams resourceType(String value) {
            this.put("resourceType", EncodingUtils.encode(value));
            return this;
        }
    }
}

