/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddAssetRequest;
import com.collibra.core.rest.client.model.AddAssetTagsRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.AssetImpl;
import com.collibra.core.rest.client.model.AssetPagedResponse;
import com.collibra.core.rest.client.model.Attribute;
import com.collibra.core.rest.client.model.ChangeAssetRequest;
import com.collibra.core.rest.client.model.NamedResourceReferenceImpl;
import com.collibra.core.rest.client.model.RelationImpl;
import com.collibra.core.rest.client.model.RemoveAssetTagsRequest;
import com.collibra.core.rest.client.model.ResponsibilityImpl;
import com.collibra.core.rest.client.model.SetAssetAttributesRequest;
import com.collibra.core.rest.client.model.SetAssetRelationsRequest;
import com.collibra.core.rest.client.model.SetAssetResponsibilitiesRequest;
import com.collibra.core.rest.client.model.SetAssetTagsRequest;
import com.collibra.core.rest.client.model.Tag;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface AssetsApi
extends ApiClient.Api {
    @RequestLine(value="POST /assets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AssetImpl addAsset(AddAssetRequest var1);

    @RequestLine(value="POST /assets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AssetImpl> addAssetWithHttpInfo(AddAssetRequest var1);

    @RequestLine(value="POST /assets/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<AssetImpl> addAssets(List<AddAssetRequest> var1);

    @RequestLine(value="POST /assets/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<AssetImpl>> addAssetsWithHttpInfo(List<AddAssetRequest> var1);

    @RequestLine(value="POST /assets/{assetId}/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Tag> addTagsToAsset(@Param(value="assetId") UUID var1, AddAssetTagsRequest var2);

    @RequestLine(value="POST /assets/{assetId}/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Tag>> addTagsToAssetWithHttpInfo(@Param(value="assetId") UUID var1, AddAssetTagsRequest var2);

    @RequestLine(value="PATCH /assets/{assetId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AssetImpl changeAsset(@Param(value="assetId") UUID var1, ChangeAssetRequest var2);

    @RequestLine(value="PATCH /assets/{assetId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AssetImpl> changeAssetWithHttpInfo(@Param(value="assetId") UUID var1, ChangeAssetRequest var2);

    @RequestLine(value="PATCH /assets/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<AssetImpl> changeAssets(List<ChangeAssetRequest> var1);

    @RequestLine(value="PATCH /assets/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<AssetImpl>> changeAssetsWithHttpInfo(List<ChangeAssetRequest> var1);

    @RequestLine(value="GET /assets?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&domainId={domainId}&communityId={communityId}&typeIds={typeIds}&typeId={typeId}&statusIds={statusIds}&statusId={statusId}&tagNames={tagNames}&typeInheritance={typeInheritance}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public AssetPagedResponse findAssets(@Param(value="sortField") String var1, @Param(value="offset") Integer var2, @Param(value="limit") Integer var3, @Param(value="countLimit") Integer var4, @Param(value="cursor") String var5, @Param(value="name") String var6, @Param(value="nameMatchMode") String var7, @Param(value="domainId") UUID var8, @Param(value="communityId") UUID var9, @Param(value="typeIds") List<UUID> var10, @Param(value="typeId") List<UUID> var11, @Param(value="statusIds") List<UUID> var12, @Param(value="statusId") List<UUID> var13, @Param(value="tagNames") List<String> var14, @Param(value="typeInheritance") Boolean var15, @Param(value="excludeMeta") Boolean var16, @Param(value="sortOrder") String var17);

    @RequestLine(value="GET /assets?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&domainId={domainId}&communityId={communityId}&typeIds={typeIds}&typeId={typeId}&statusIds={statusIds}&statusId={statusId}&tagNames={tagNames}&typeInheritance={typeInheritance}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetPagedResponse> findAssetsWithHttpInfo(@Param(value="sortField") String var1, @Param(value="offset") Integer var2, @Param(value="limit") Integer var3, @Param(value="countLimit") Integer var4, @Param(value="cursor") String var5, @Param(value="name") String var6, @Param(value="nameMatchMode") String var7, @Param(value="domainId") UUID var8, @Param(value="communityId") UUID var9, @Param(value="typeIds") List<UUID> var10, @Param(value="typeId") List<UUID> var11, @Param(value="statusIds") List<UUID> var12, @Param(value="statusId") List<UUID> var13, @Param(value="tagNames") List<String> var14, @Param(value="typeInheritance") Boolean var15, @Param(value="excludeMeta") Boolean var16, @Param(value="sortOrder") String var17);

    @RequestLine(value="GET /assets?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&domainId={domainId}&communityId={communityId}&typeIds={typeIds}&typeId={typeId}&statusIds={statusIds}&statusId={statusId}&tagNames={tagNames}&typeInheritance={typeInheritance}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public AssetPagedResponse findAssets(@QueryMap(encoded=true) FindAssetsQueryParams var1);

    @RequestLine(value="GET /assets?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&domainId={domainId}&communityId={communityId}&typeIds={typeIds}&typeId={typeId}&statusIds={statusIds}&statusId={statusId}&tagNames={tagNames}&typeInheritance={typeInheritance}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetPagedResponse> findAssetsWithHttpInfo(@QueryMap(encoded=true) FindAssetsQueryParams var1);

    @RequestLine(value="GET /assets/{assetId}")
    @Headers(value={"Accept: application/json"})
    public AssetImpl getAsset(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assets/{assetId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetImpl> getAssetWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assets/{assetId}/breadcrumb")
    @Headers(value={"Accept: application/json"})
    public List<NamedResourceReferenceImpl> getAssetBreadcrumb(@Param(value="assetId") String var1);

    @RequestLine(value="GET /assets/{assetId}/breadcrumb")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<NamedResourceReferenceImpl>> getAssetBreadcrumbWithHttpInfo(@Param(value="assetId") String var1);

    @RequestLine(value="GET /assets/{assetId}/tags")
    @Headers(value={"Accept: application/json"})
    public List<Tag> getAssetTags(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /assets/{assetId}/tags")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Tag>> getAssetTagsWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="DELETE /assets/{assetId}")
    @Headers(value={"Accept: application/json"})
    public void removeAsset(@Param(value="assetId") UUID var1);

    @RequestLine(value="DELETE /assets/{assetId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeAssetWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="DELETE /assets/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeAssets(List<UUID> var1);

    @RequestLine(value="DELETE /assets/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeAssetsWithHttpInfo(List<UUID> var1);

    @RequestLine(value="DELETE /assets/{assetId}/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeTagsFromAsset(@Param(value="assetId") UUID var1, RemoveAssetTagsRequest var2);

    @RequestLine(value="DELETE /assets/{assetId}/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeTagsFromAssetWithHttpInfo(@Param(value="assetId") UUID var1, RemoveAssetTagsRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/attributes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Attribute> setAssetAttributes(@Param(value="assetId") UUID var1, SetAssetAttributesRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/attributes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Attribute>> setAssetAttributesWithHttpInfo(@Param(value="assetId") UUID var1, SetAssetAttributesRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/relations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<RelationImpl> setAssetRelations(@Param(value="assetId") UUID var1, SetAssetRelationsRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/relations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<RelationImpl>> setAssetRelationsWithHttpInfo(@Param(value="assetId") UUID var1, SetAssetRelationsRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/responsibilities")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<ResponsibilityImpl> setAssetResponsibilities(@Param(value="assetId") UUID var1, SetAssetResponsibilitiesRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/responsibilities")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<ResponsibilityImpl>> setAssetResponsibilitiesWithHttpInfo(@Param(value="assetId") UUID var1, SetAssetResponsibilitiesRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Tag> setTagsForAsset(@Param(value="assetId") UUID var1, SetAssetTagsRequest var2);

    @RequestLine(value="PUT /assets/{assetId}/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Tag>> setTagsForAssetWithHttpInfo(@Param(value="assetId") UUID var1, SetAssetTagsRequest var2);

    public static class FindAssetsQueryParams
    extends HashMap<String, Object> {
        public FindAssetsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams cursor(String value) {
            this.put("cursor", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams domainId(UUID value) {
            this.put("domainId", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams communityId(UUID value) {
            this.put("communityId", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams typeIds(List<UUID> value) {
            this.put("typeIds", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindAssetsQueryParams typeId(List<UUID> value) {
            this.put("typeId", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindAssetsQueryParams statusIds(List<UUID> value) {
            this.put("statusIds", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindAssetsQueryParams statusId(List<UUID> value) {
            this.put("statusId", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindAssetsQueryParams tagNames(List<String> value) {
            this.put("tagNames", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindAssetsQueryParams typeInheritance(Boolean value) {
            this.put("typeInheritance", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams excludeMeta(Boolean value) {
            this.put("excludeMeta", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams sortField(String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetsQueryParams sortOrder(String value) {
            this.put("sortOrder", EncodingUtils.encode(value));
            return this;
        }
    }
}

