/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddAssetTypeRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.core.rest.client.model.AssetTypePagedResponse;
import com.collibra.core.rest.client.model.ChangeAssetTypeRequest;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface AssetTypesApi
extends ApiClient.Api {
    @RequestLine(value="POST /assetTypes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AssetTypeImpl addAssetType(AddAssetTypeRequest var1);

    @RequestLine(value="POST /assetTypes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AssetTypeImpl> addAssetTypeWithHttpInfo(AddAssetTypeRequest var1);

    @RequestLine(value="POST /assetTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<AssetTypeImpl> addAssetTypes(List<AddAssetTypeRequest> var1);

    @RequestLine(value="POST /assetTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<AssetTypeImpl>> addAssetTypesWithHttpInfo(List<AddAssetTypeRequest> var1);

    @RequestLine(value="PATCH /assetTypes/{assetTypeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AssetTypeImpl changeAssetType(@Param(value="assetTypeId") UUID var1, ChangeAssetTypeRequest var2);

    @RequestLine(value="PATCH /assetTypes/{assetTypeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AssetTypeImpl> changeAssetTypeWithHttpInfo(@Param(value="assetTypeId") UUID var1, ChangeAssetTypeRequest var2);

    @RequestLine(value="PATCH /assetTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<AssetTypeImpl> changeAssetTypes(List<ChangeAssetTypeRequest> var1);

    @RequestLine(value="PATCH /assetTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<AssetTypeImpl>> changeAssetTypesWithHttpInfo(List<ChangeAssetTypeRequest> var1);

    @RequestLine(value="GET /assetTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&excludeFinal={excludeFinal}&excludeUnlicensedProducts={excludeUnlicensedProducts}&topLevel={topLevel}&displayNameEnabled={displayNameEnabled}")
    @Headers(value={"Accept: application/json"})
    public AssetTypePagedResponse findAssetTypes(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="parentId") UUID var6, @Param(value="excludeMeta") Boolean var7, @Param(value="excludeFinal") Boolean var8, @Param(value="excludeUnlicensedProducts") Boolean var9, @Param(value="topLevel") Boolean var10, @Param(value="displayNameEnabled") Boolean var11);

    @RequestLine(value="GET /assetTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&excludeFinal={excludeFinal}&excludeUnlicensedProducts={excludeUnlicensedProducts}&topLevel={topLevel}&displayNameEnabled={displayNameEnabled}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetTypePagedResponse> findAssetTypesWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="parentId") UUID var6, @Param(value="excludeMeta") Boolean var7, @Param(value="excludeFinal") Boolean var8, @Param(value="excludeUnlicensedProducts") Boolean var9, @Param(value="topLevel") Boolean var10, @Param(value="displayNameEnabled") Boolean var11);

    @RequestLine(value="GET /assetTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&excludeFinal={excludeFinal}&excludeUnlicensedProducts={excludeUnlicensedProducts}&topLevel={topLevel}&displayNameEnabled={displayNameEnabled}")
    @Headers(value={"Accept: application/json"})
    public AssetTypePagedResponse findAssetTypes(@QueryMap(encoded=true) FindAssetTypesQueryParams var1);

    @RequestLine(value="GET /assetTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&excludeFinal={excludeFinal}&excludeUnlicensedProducts={excludeUnlicensedProducts}&topLevel={topLevel}&displayNameEnabled={displayNameEnabled}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetTypePagedResponse> findAssetTypesWithHttpInfo(@QueryMap(encoded=true) FindAssetTypesQueryParams var1);

    @RequestLine(value="GET /assetTypes/{assetTypeId}/parents")
    @Headers(value={"Accept: application/json"})
    public List<AssetTypeImpl> findParentTypes(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="GET /assetTypes/{assetTypeId}/parents")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<AssetTypeImpl>> findParentTypesWithHttpInfo(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="GET /assetTypes/{assetTypeId}/subTypes?includeParent={includeParent}&directSubTypesOnly={directSubTypesOnly}")
    @Headers(value={"Accept: application/json"})
    public AssetTypePagedResponse findSubAssetTypes(@Param(value="assetTypeId") UUID var1, @Param(value="includeParent") Boolean var2, @Param(value="directSubTypesOnly") Boolean var3);

    @RequestLine(value="GET /assetTypes/{assetTypeId}/subTypes?includeParent={includeParent}&directSubTypesOnly={directSubTypesOnly}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetTypePagedResponse> findSubAssetTypesWithHttpInfo(@Param(value="assetTypeId") UUID var1, @Param(value="includeParent") Boolean var2, @Param(value="directSubTypesOnly") Boolean var3);

    @RequestLine(value="GET /assetTypes/{assetTypeId}/subTypes?includeParent={includeParent}&directSubTypesOnly={directSubTypesOnly}")
    @Headers(value={"Accept: application/json"})
    public AssetTypePagedResponse findSubAssetTypes(@Param(value="assetTypeId") UUID var1, @QueryMap(encoded=true) FindSubAssetTypesQueryParams var2);

    @RequestLine(value="GET /assetTypes/{assetTypeId}/subTypes?includeParent={includeParent}&directSubTypesOnly={directSubTypesOnly}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetTypePagedResponse> findSubAssetTypesWithHttpInfo(@Param(value="assetTypeId") UUID var1, @QueryMap(encoded=true) FindSubAssetTypesQueryParams var2);

    @RequestLine(value="GET /assetTypes/{assetTypeId}")
    @Headers(value={"Accept: application/json"})
    public AssetTypeImpl getAssetType(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="GET /assetTypes/{assetTypeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetTypeImpl> getAssetTypeWithHttpInfo(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="DELETE /assetTypes/{assetTypeId}")
    @Headers(value={"Accept: application/json"})
    public void removeAssetType(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="DELETE /assetTypes/{assetTypeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeAssetTypeWithHttpInfo(@Param(value="assetTypeId") UUID var1);

    @RequestLine(value="DELETE /assetTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeAssetTypes(List<UUID> var1);

    @RequestLine(value="DELETE /assetTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeAssetTypesWithHttpInfo(List<UUID> var1);

    public static class FindSubAssetTypesQueryParams
    extends HashMap<String, Object> {
        public FindSubAssetTypesQueryParams includeParent(Boolean value) {
            this.put("includeParent", EncodingUtils.encode(value));
            return this;
        }

        public FindSubAssetTypesQueryParams directSubTypesOnly(Boolean value) {
            this.put("directSubTypesOnly", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class FindAssetTypesQueryParams
    extends HashMap<String, Object> {
        public FindAssetTypesQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams parentId(UUID value) {
            this.put("parentId", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams excludeMeta(Boolean value) {
            this.put("excludeMeta", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams excludeFinal(Boolean value) {
            this.put("excludeFinal", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams excludeUnlicensedProducts(Boolean value) {
            this.put("excludeUnlicensedProducts", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams topLevel(Boolean value) {
            this.put("topLevel", EncodingUtils.encode(value));
            return this;
        }

        public FindAssetTypesQueryParams displayNameEnabled(Boolean value) {
            this.put("displayNameEnabled", EncodingUtils.encode(value));
            return this;
        }
    }
}

